import ddf.minim.spi.*;
import ddf.minim.signals.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.ugens.*;
import ddf.minim.effects.*;

//CHALLENGE ME

//sound
Minim minim;
AudioPlayer bgsound;


ArrayList clouds;
ArrayList assignments;
ArrayList obstacles;

int score = 0;
int miss = 0;
int posX = 150;
int posY = 465;
float speedY = 0;
boolean isMoving = false;
int gameStart = 1;
float scale;
float acce = 0.95;
float gravity = 0.3;

PImage ground;
PImage cloud;
PImage assignment;
PImage me;
PImage meSick;
PImage runningright;
PImage runningleft;





void setup() {
  size(800, 600);

  ground = loadImage("ChallengeGame-ground.png");
  cloud = loadImage ("cloud.png");
  assignment = loadImage ("assignment.png");
  me = loadImage("me.png");
  meSick = loadImage("meSick.png");
  runningright = loadImage("runningright.png");
  runningleft = loadImage("runningleft.png");

  minim = new Minim(this);
  bgsound = minim.loadFile("Rolemusic_-_Gringo_Steele_rocks_the_40.mp3");

  clouds = new ArrayList();
  assignments = new ArrayList();
  obstacles = new ArrayList();
}

void draw() {
  background(40, 220, 220);
  image (ground, 0, 0 );

  // 1 first start game
  // 2 play game
  // 3 after not collecting assignment
  // 4 game over after hitting obstacle
  // 5 is after time

  if (gameStart == 1) {
    drawMe();
    image (cloud, 100, 100);
    image (cloud, 200, 350);
    image (cloud, 650, 275);
    fill(255);
    textSize(80);
    text("BOOTCAMP", width/2, height/2 - 100); 
    scale = map(sin(frameCount/2), -1, 1, 200, 255);
    fill(255, 255, 255, scale);
    textAlign (CENTER);
    textSize(20);
    text("Click to start.", width/2, height/2);
    bgsound.play();
  }

  if (gameStart == 2) {
    cloudsArray();
    obstaclesArray();
    assignmentsArray();
    score();
    running();
    jump();
    bgsound.play();
    if (frameCount <= 180) {
      fill(255);
      textAlign (LEFT);
      textSize(20);
      text("Jump to collect assignments.", 30, 100);
    }

    if (frameCount > 180 && frameCount <= 360) {
      fill(255);
      textAlign (LEFT);
      textSize(20);
      text("Use UP arrow key and avoid blocks.", 30, 100);
    }
  }

  if (gameStart == 3 || gameStart == 5) {
    assignments.clear();
    clouds.clear();
    obstacles.clear();

    drawMe();
    image (cloud, 100, 100);
    image (cloud, 200, 300);
    image (cloud, 650, 275);
    fill(255);
    textSize(80);
    text("BOOTCAMP", width/2, height/2 - 100); 
    textSize(20);
    fill(255, 250, 0);
    text ("You failed, because you missed 5 assignments.", width/2, height - 200);
    text ("Assignments done: " + " " + score, width/2, height - 160);    
    scale = map(sin(frameCount/2), -1, 1, 200, 255);
    fill(255, 255, 255, scale);
    textAlign (CENTER);
    textSize(20);
    text("Click to start.", width/2, height/2);
  }

  if (gameStart == 4) {
    assignments.clear();
    clouds.clear();
    obstacles.clear();

    drawMeSick();
    image (cloud, 100, 100);
    image (cloud, 200, 300);
    image (cloud, 650, 275);
    fill(255);
    textSize(80);
    text("BOOTCAMP", width/2, height/2 - 100); 
    textSize(20);
    fill(255, 250, 0);
    text ("Ooooh No! You got sick at Bootcamp.", width/2, height - 200);
    text ("Assignments done: " + " " + score, width/2, height - 160);
    scale = map(sin(frameCount/2), -1, 1, 200, 255);
    fill(255, 255, 255, scale);
    textAlign (CENTER);
    textSize(20);
    text("Click to start.", width/2, height/2);
  }


  for (int i = 0; i < assignments.size (); i++) {
    Assignment a = (Assignment) assignments.get(i); // posX of a - a.posX
    if (posX + 60 > a.posX && // right of me (60, 85) and left of assignment(40, 55)
    posX < a.posX + 40 && // left of me and right of assignment
    posY + 85 > a.posY && 
      posY < a.posY + 55) {
      textSize(40);
      score += 1;
      background (255, 250, 0);
      assignments.remove(i);
    }

    if (a.posX + 40 < 150) { // if right of assignment smaller than 0
      miss++;
      assignments.remove(i);
    }
  }

  if (miss == 5) {
    gameStart = 3;
    assignments.clear();
    clouds.clear();
    obstacles.clear();
  }

  for (int i = 0; i < obstacles.size (); i++) {
    Obstacle o = (Obstacle) obstacles.get(i); // posX of a - a.posX
    if (posX + 60 > o.posX && // right of me (60, 85) and left of obstacle(40, 80)
    posX < o.posX + 40 && // left of me and right of obstacle
    posY + 85 > o.posY && 
      posY < o.posY + 80) {
      gameStart = 4; // game ends after hitting obstacle
    }
  }

  if (gameStart == 2 && frameCount > 3600) {
    gameStart = 5; //because game ends after spec. time
  }
} // End void draw()


void mouseClicked () {
  // start the game
  if (gameStart != 2) {
    gameStart = 2;
    frameCount = 0;
    score = 0;
    miss = 0;
    assignments.clear();
    clouds.clear();
    obstacles.clear();
  }
}


//////////////////////////////////////Game start = true

void jump() {
  if (keyPressed && key == CODED) {
    if (keyCode == UP) {
      speedY = -2;
    }
  }

  speedY += gravity;  
  posY += speedY;

  if (posY > 465) {

    //limit posY
    posY = 465;  

    //bounce
    speedY = speedY * -0.3;
  }
}


void assignmentsArray() {
  //assignments
  for (int i = 0; i < assignments.size (); i++) {
    Assignment l = (Assignment) assignments.get(i);
    l.moveAssignment();
    l.displayAssignment();
  }

  //% big = less
  if (frameCount == 10 || frameCount == 270 || frameCount%183 == 0) {
    assignments.add(new Assignment(800, 400));
  }
}


void obstaclesArray() {
  //obstacles
  for (int i = 0; i < obstacles.size (); i++) {
    Obstacle l = (Obstacle) obstacles.get(i);
    l.moveObstacle();
    l.displayObstacle();
  }

  //% big = less
  if (frameCount == 30 || frameCount%783 == 0) {
    obstacles.add(new Obstacle(800, 470) );
  }
}


void cloudsArray() {
  //clouds
  for (int i = 0; i < clouds.size (); i++) {
    Cloud l = (Cloud) clouds.get(i);
    l.moveCloud();
    l.displayCloud();
  }

  //% big = less
  if (frameCount == 1 || frameCount%378 == 0) {
    clouds.add(new Cloud(800, 400) );
  }
}



void running () {
  if (frameCount%20 == 0) {
    isMoving = !isMoving;
  }

  if (isMoving == true) {
    runningleft();
  } else {
    runningright();
  }
}


void runningright() {
  image (runningright, posX, posY );
}

void runningleft() {
  image (runningleft, posX, posY );
}


void score() {
  textAlign(LEFT);
  textSize(20);
  fill(0);
  text ("Assignments done: " + " " + score, 30, 50);
  textAlign(RIGHT);
  text (" Assignments missed: " + " " + miss, 770, 50);
}


////////////////////////////Game start = false

void drawMe () {
  image (me, 150, 465 );
}

void drawMeSick () {
  image (meSick, width/2-40, 490 );
}

